/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ReadWriteLockTesterSwing {
    private ReentrantReadWriteLock rwlock;
    private final JTextArea text = new JTextArea();
    private static final Object READ_MUTEX = new Object();
    private static final Object WRITE_MUTEX = new Object();
    private final JPanel buttons = new JPanel(new GridLayout(1, 6));
    private final ExecutorService pool = Executors.newCachedThreadPool();

    public static void main(String[] stringArray) {
        new ReadWriteLockTesterSwing();
    }

    public ReadWriteLockTesterSwing() {
        JFrame jFrame = new JFrame("ReadWriteLock tester");
        jFrame.setBounds(100, 100, 1000, 600);
        JPanel jPanel = new JPanel(new BorderLayout());
        jFrame.getContentPane().add("Center", jPanel);
        jFrame.setDefaultCloseOperation(3);
        jPanel.add("North", this.buttons);
        jPanel.add("Center", this.text);
        this.createDefaultRWLock();
        this.createButton("clear", new Runnable(){

            @Override
            public void run() {
                ReadWriteLockTesterSwing.this.text.setText("");
            }
        });
        this.createButton("construct default", new Runnable(){

            @Override
            public void run() {
                ReadWriteLockTesterSwing.this.createDefaultRWLock();
            }
        });
        this.createButton("construct fair", new Runnable(){

            @Override
            public void run() {
                ReadWriteLockTesterSwing.this.createFairRWLock();
            }
        });
        this.createButton("readLock", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ReadWriteLockTesterSwing.this.rwlock.readLock().lock();
                ReadWriteLockTesterSwing.this.text.append(">>>> read lock acquired" + ReadWriteLockTesterSwing.this.status());
                Object object = READ_MUTEX;
                synchronized (object) {
                    try {
                        READ_MUTEX.wait();
                        ReadWriteLockTesterSwing.this.rwlock.readLock().unlock();
                        ReadWriteLockTesterSwing.this.text.append("<<<< read lock released" + ReadWriteLockTesterSwing.this.status());
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        this.createButton("writeLock", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ReadWriteLockTesterSwing.this.rwlock.writeLock().lock();
                ReadWriteLockTesterSwing.this.text.append(">>>> write lock acquired" + ReadWriteLockTesterSwing.this.status());
                Object object = WRITE_MUTEX;
                synchronized (object) {
                    try {
                        WRITE_MUTEX.wait();
                        ReadWriteLockTesterSwing.this.rwlock.writeLock().unlock();
                        ReadWriteLockTesterSwing.this.text.append("<<<< write lock released" + ReadWriteLockTesterSwing.this.status());
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        this.createButton("readRelease", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = READ_MUTEX;
                synchronized (object) {
                    READ_MUTEX.notify();
                }
            }
        });
        this.createButton("writeRelease", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = WRITE_MUTEX;
                synchronized (object) {
                    WRITE_MUTEX.notify();
                }
            }
        });
        jFrame.setVisible(true);
    }

    private String status() {
        return " read locks:" + this.rwlock.getReadLockCount() + " writeLocks:" + this.rwlock.getWriteHoldCount() + " waiting:" + this.rwlock.getQueueLength() + "\n";
    }

    private void createButton(String string, final Runnable runnable) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReadWriteLockTesterSwing.this.pool.execute(runnable);
            }
        });
        this.buttons.add(jButton);
    }

    private void createDefaultRWLock() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ReadWriteLockTesterSwing.this.rwlock = new ReentrantReadWriteLock(false);
                ReadWriteLockTesterSwing.this.text.append("new ReentrantReadWriteLock(false)\n");
            }
        }).start();
    }

    private void createFairRWLock() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ReadWriteLockTesterSwing.this.reset();
                ReadWriteLockTesterSwing.this.rwlock = new ReentrantReadWriteLock(true);
                ReadWriteLockTesterSwing.this.text.append("new ReentrantReadWriteLock(true)\n");
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        try {
            while (this.rwlock.getReadLockCount() > 0 || this.rwlock.getWriteHoldCount() > 0) {
                Object object = READ_MUTEX;
                synchronized (object) {
                    READ_MUTEX.notifyAll();
                }
                object = WRITE_MUTEX;
                synchronized (object) {
                    WRITE_MUTEX.notifyAll();
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

